package objectos_casa;

import javax.imageio.ImageIO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

/**
 * Created by Pedro on 06/04/2016.
 */
public class Function_call extends ObjectoCasa {
    public String nome;
    public String tipo_objecto_retorno;
    public ArrayList <String> argumentos;
    public ArrayList <String> tipo_argumentos;

    public Function_call(int numero_id, String identificador, String tipo){
        path_icone = "function_call.bmp";
        id=numero_id;
        nome=identificador;
        tipo_objecto_retorno=tipo;
        argumentos=new ArrayList<>();
        tipo_argumentos= new ArrayList<>();
    }

    public void setNome(String n){
        nome=n;
    }

    public void addArg (String arg, String tipo){
        argumentos.add(arg);
        tipo_argumentos.add(tipo);
    }

    public void removeArg (int index){
        argumentos.remove(index);
        tipo_argumentos.remove(index);
    }

    public String printArgumentosTipos(){
        String param="";
        int pos=0;
        for(String s:argumentos) {
            param += "|Arg. Nº"+(pos+1)+"- nome: " + s + "tipo: " + tipo_argumentos.get(pos) + "|\n";
            pos++;
        }

        return param;
    }

    public String gerar(){
        return nome+argumentos.toString().replace('[','(').replace(']',')')+'\n';
    }

    @Override
    public String tipo_objecto(){return "function_call";}

    public String to_expressao() {
        return nome;
    }


}